<?php

namespace App\Http\Controllers;

use App\Models\Device;
use Illuminate\Http\Request;

class DeviceController extends Controller
{
    public function linkDevice(string $uuid)
    {
        $device = Device::query()->where('uuid', $uuid)->firstOrFail();

        if ($device){
            if (is_null($device->user_id)){
                $device->update([
                    'user_id' => auth()->id()
                ]);
            }else if (!is_null($device->review_url)){
                return redirect()->away($device->review_url);
            }
        }

        return redirect('devices/'.$device->id.'/setup');
    }
}
