<?php

namespace App\Filament\Resources\Admins\Schemas;

use App\Enums\SystemRole;
use Filament\Forms\Components\MultiSelect;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Resources\Pages\CreateRecord;
use Filament\Resources\Pages\EditRecord;
use Filament\Schemas\Schema;
use Illuminate\Support\Facades\Hash;

class AdminForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->required()
                    ->maxLength(255),

                TextInput::make('email')
                    ->email()
                    ->required()
                    ->maxLength(255),

                TextInput::make('password')
                    ->password()
                    ->required(fn ($livewire, $get) => $livewire instanceof CreateRecord)
                    ->dehydrateStateUsing(fn ($state) => $state ? Hash::make($state) : null)
                    ->dehydrated(fn ($state) => filled($state))
                    ->hint(fn ($livewire, $get) => $livewire instanceof EditRecord
                        ? 'Leave blank to keep the current password unchanged.'
                        : null),

                MultiSelect::make('roles')
                    ->label('Roles')
                    ->relationship('roles', 'name', function ($query) {
                        return $query->whereNotIn('name', SystemRole::values());
                    })
                    ->maxItems(1)
                    ->preload()
                    ->required(),

                Toggle::make('is_active')
                ->label('Status')
                ->inline(false)
                ->default(false)
            ]);
    }
}
