<?php

namespace App\Enums;

enum SystemRole : string
{
    use BaseEnum;

    case SUPER_ADMIN = 'super_admin';
    case User = 'user';

    public function label(): string
    {
        return match($this) {
            self::SUPER_ADMIN => 'Super Admin',
            self::User => 'User'
        };
    }
}
