<?php

namespace App\Enums;

enum Platform : string
{
    use BaseEnum;

    case GOOGLE = 'google';
    case YELP = 'yelp';

    public function label(): string
    {
        return match($this) {
            self::GOOGLE => 'Google',
            self::YELP => 'Yelp'
        };
    }
}
