<?php

namespace App\Enums;

enum DeviceType : string
{
    use BaseEnum;

    case NFC = 'nfc';
    case QR = 'qr';
    case NFC_QR = 'nfc_qr';

    public function label(): string
    {
        return match($this) {
            self::NFC => 'NFC',
            self::QR => 'QR',
            self::NFC_QR => 'NFC + QR'
        };
    }
}
